/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.controller;

import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoCreateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoResponse;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.service.IProductoAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/catalogo/productos"})
@Validated
public class ProductoAdminController {
    private final IProductoAdminService productoAdminService;

    @GetMapping
    public ResponseEntity<List<ProductoResponse>> listar(@PathVariable Long tiendaId, @RequestParam(value="categoriaId", required=false) Long categoriaId) {
        return ResponseEntity.ok((Object)this.productoAdminService.listar(tiendaId, categoriaId));
    }

    @GetMapping(value={"/{productoId}"})
    public ResponseEntity<ProductoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long productoId) {
        return ResponseEntity.ok((Object)this.productoAdminService.obtener(tiendaId, productoId));
    }

    @PostMapping
    public ResponseEntity<ProductoResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody ProductoCreateRequest request) {
        ProductoResponse response = this.productoAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{productoId}"})
    public ResponseEntity<ProductoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long productoId, @Valid @RequestBody ProductoUpdateRequest request) {
        ProductoResponse response = this.productoAdminService.actualizar(tiendaId, productoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{productoId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long productoId) {
        this.productoAdminService.eliminar(tiendaId, productoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ProductoAdminController(IProductoAdminService productoAdminService) {
        this.productoAdminService = productoAdminService;
    }
}

