/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.controller;

import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaCreateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaResponse;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.service.ICategoriaAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/catalogo/categorias"})
@Validated
public class CategoriaAdminController {
    private final ICategoriaAdminService categoriaAdminService;

    @GetMapping
    public ResponseEntity<List<CategoriaResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.categoriaAdminService.listar(tiendaId));
    }

    @GetMapping(value={"/{categoriaId}"})
    public ResponseEntity<CategoriaResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long categoriaId) {
        return ResponseEntity.ok((Object)this.categoriaAdminService.obtener(tiendaId, categoriaId));
    }

    @PostMapping
    public ResponseEntity<CategoriaResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody CategoriaCreateRequest request) {
        CategoriaResponse response = this.categoriaAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{categoriaId}"})
    public ResponseEntity<CategoriaResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long categoriaId, @Valid @RequestBody CategoriaUpdateRequest request) {
        CategoriaResponse response = this.categoriaAdminService.actualizar(tiendaId, categoriaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{categoriaId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long categoriaId) {
        this.categoriaAdminService.eliminar(tiendaId, categoriaId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public CategoriaAdminController(ICategoriaAdminService categoriaAdminService) {
        this.categoriaAdminService = categoriaAdminService;
    }
}

