/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.Registros;
import fisi.unsm.api.security.JwtUtil;
import fisi.unsm.api.service.IRegistrosService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class RegistrosController {
    @Autowired
    private IRegistrosService serviceRegistros;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;

    @GetMapping(value={"/registros"})
    public List<Registros> buscartodos() {
        return this.serviceRegistros.buscarTodos();
    }

    @PostMapping(value={"/registros"})
    public Registros guardar(@RequestBody Registros registro) {
        registro.setCliente_id(null);
        String claveOriginal = registro.getEmail() + registro.getNombres() + registro.getApellidos();
        registro.setLlave_secreta(claveOriginal);
        this.serviceRegistros.guardar(registro);
        return registro;
    }

    @PutMapping(value={"/registros"})
    public Registros modificar(@RequestBody Registros registro) {
        this.serviceRegistros.modificar(registro);
        return registro;
    }

    @GetMapping(value={"/registros/{id}"})
    public Optional<Registros> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceRegistros.buscarId(id);
    }

    @DeleteMapping(value={"/registros/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceRegistros.eliminar(id);
        return "Registro eliminado";
    }

    @PostMapping(value={"/token"})
    public ResponseEntity<?> obtenerToken(@RequestBody Map<String, String> credenciales) {
        String clienteId = credenciales.get("cliente_id");
        String llaveSecreta = credenciales.get("llave_secreta");
        Optional<Registros> user = this.serviceRegistros.buscarTodos().stream().filter(r -> r.getCliente_id().equals(clienteId)).findFirst();
        if (user.isPresent() && this.passwordEncoder.matches((CharSequence)llaveSecreta, user.get().getLlave_secreta())) {
            String token = this.jwtUtil.generarToken(clienteId);
            Registros registro = user.get();
            registro.setAccess_token(token);
            this.serviceRegistros.modificar(registro);
            return ResponseEntity.ok(Collections.singletonMap("token", token));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales incorrectas");
    }
}

