/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.Cursos;
import fisi.unsm.api.service.ICursosService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/NaturalezasCursos"})
public class NaturalezasCursosController {
    @Autowired
    private ICursosService serviceCursos;

    @GetMapping(value={"/cursos"})
    public List<Cursos> buscartodos() {
        return this.serviceCursos.buscarTodos();
    }

    @PostMapping(value={"/cursos"})
    public Cursos guardar(@RequestBody Cursos curso) {
        this.serviceCursos.guardar(curso);
        return curso;
    }

    @PutMapping(value={"/cursos"})
    public Cursos modificar(@RequestBody Cursos curso) {
        this.serviceCursos.modificar(curso);
        return curso;
    }

    @GetMapping(value={"/cursos/{id}"})
    public Optional<Cursos> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceCursos.buscarId(id);
    }

    @DeleteMapping(value={"/cursos/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceCursos.eliminar(id);
        return "Curso eliminado";
    }
}

