/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.CategoriasCursos;
import fisi.unsm.api.entity.Cursos;
import fisi.unsm.api.entity.CursosDTO;
import fisi.unsm.api.entity.NaturalezasCursos;
import fisi.unsm.api.entity.TiposCursos;
import fisi.unsm.api.repository.CategoriasCursosRepository;
import fisi.unsm.api.repository.NaturalezasCursosRepository;
import fisi.unsm.api.repository.TiposCursosRepository;
import fisi.unsm.api.service.ICursosService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class CursosController {
    @Autowired
    private ICursosService serviceCursos;
    @Autowired
    private TiposCursosRepository repoTiposCurso;
    @Autowired
    private CategoriasCursosRepository repoCategoriasCurso;
    @Autowired
    private NaturalezasCursosRepository repoNaturalezasCurso;

    @GetMapping(value={"/cursos"})
    public List<Cursos> buscartodos() {
        return this.serviceCursos.buscarTodos();
    }

    @PostMapping(value={"/cursos"})
    public ResponseEntity<?> guardar(@RequestBody CursosDTO cursoDTO) {
        Cursos curso = new Cursos();
        curso.setDescripcion(cursoDTO.getDescripcion());
        TiposCursos tipo = this.repoTiposCurso.findById((Object)cursoDTO.getId_tipo()).orElse(null);
        CategoriasCursos categoria = this.repoCategoriasCurso.findById((Object)cursoDTO.getId_categoria()).orElse(null);
        NaturalezasCursos naturaleza = this.repoNaturalezasCurso.findById((Object)cursoDTO.getId_naturaleza()).orElse(null);
        curso.setId_tipo(tipo);
        curso.setId_categoria(categoria);
        curso.setId_naturaleza(naturaleza);
        return ResponseEntity.ok((Object)this.serviceCursos.guardar(curso));
    }

    @PutMapping(value={"/cursos"})
    public ResponseEntity<?> modificar(@RequestBody CursosDTO cursoDTO) {
        if (cursoDTO.getIdcurso() == null) {
            return ResponseEntity.badRequest().body((Object)"El ID del curso es obligatorio para modificar.");
        }
        Cursos curso = new Cursos();
        curso.setIdcurso(cursoDTO.getIdcurso());
        curso.setDescripcion(cursoDTO.getDescripcion());
        curso.setId_tipo(new TiposCursos(cursoDTO.getId_tipo()));
        curso.setId_categoria(new CategoriasCursos(cursoDTO.getId_categoria()));
        curso.setId_naturaleza(new NaturalezasCursos(cursoDTO.getId_naturaleza()));
        return ResponseEntity.ok((Object)this.serviceCursos.modificar(curso));
    }

    @GetMapping(value={"/cursos/{id}"})
    public Optional<Cursos> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceCursos.buscarId(id);
    }

    @DeleteMapping(value={"/cursos/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceCursos.eliminar(id);
        return "Curso eliminado";
    }
}

