/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.Clientes;
import fisi.unsm.api.service.IClientesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class ClientesController {
    @Autowired
    private IClientesService serviceClientes;

    @GetMapping(value={"/clientes"})
    public List<Clientes> buscartodos() {
        return this.serviceClientes.buscarTodos();
    }

    @PostMapping(value={"/clientes"})
    public Clientes guardar(@RequestBody Clientes cliente) {
        this.serviceClientes.guardar(cliente);
        return cliente;
    }

    @PutMapping(value={"/clientes"})
    public Clientes modificar(@RequestBody Clientes cliente) {
        this.serviceClientes.modificar(cliente);
        return cliente;
    }

    @GetMapping(value={"/clientes/{id}"})
    public Optional<Clientes> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceClientes.buscarId(id);
    }

    @DeleteMapping(value={"/clientes/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceClientes.eliminar(id);
        return "Cliente eliminado";
    }
}

