/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.CategoriasCursos;
import fisi.unsm.api.service.ICategoriasCursoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class CategoriasCursoController {
    @Autowired
    private ICategoriasCursoService serviceCategoriasCurso;

    @GetMapping(value={"/categoriascurso"})
    public List<CategoriasCursos> buscartodos() {
        return this.serviceCategoriasCurso.buscarTodos();
    }

    @PostMapping(value={"/categoriascurso"})
    public CategoriasCursos guardar(@RequestBody CategoriasCursos categoriasCurso) {
        this.serviceCategoriasCurso.guardar(categoriasCurso);
        return categoriasCurso;
    }

    @PutMapping(value={"/categoriascurso"})
    public CategoriasCursos modificar(@RequestBody CategoriasCursos categoriasCurso) {
        this.serviceCategoriasCurso.modificar(categoriasCurso);
        return categoriasCurso;
    }

    @GetMapping(value={"/categoriascurso/{id}"})
    public Optional<CategoriasCursos> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceCategoriasCurso.buscarId(id);
    }

    @DeleteMapping(value={"/categoriascurso/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceCategoriasCurso.eliminar(id);
        return "Categoria de curso eliminada";
    }
}

